/*:
 * @target MZ
 * @plugindesc Restricts player movement to tiles with specific region numbers.
 * Author: Clay Davis
 * @help This plugin restricts player movement to tiles with specific region numbers.
 * The player can only walk on tiles with region numbers 1, 2, 3, 4, 5, or 10.
 * 
 * Author: Clay Davis
 */

(() => {
    const _Game_Player_canPass = Game_Player.prototype.canPass;

    Game_Player.prototype.canPass = function(x, y, d) {
        const newX = $gameMap.roundXWithDirection(x, d);
        const newY = $gameMap.roundYWithDirection(y, d);
        const regionId = $gameMap.regionId(newX, newY);

        // Allow passage based on regions
        if ([1, 2, 3, 4, 5, 10].includes(regionId)) return _Game_Player_canPass.call(this, x, y, d);

        // Block passage otherwise
        return false;
    };
})();